# i-doit pro Add-on: Forms

`i-doit pro Add-on: Forms` enables you to create forms that you can send to other employees to fill out via a link.

Using the add-on, you can create a form that, for example, helps new employees to document computers in your company.

When creating new objects, it is often the case that several categories are displayed, but only individual fields from each category have to be filled.

In this case, it is easier for the user (especially if they are new colleagues) if only the attributes that actually have to be filled out are displayed.

## Knowledge base

You can read the complete user manual in the following articles:
* [English](https://kb.i-doit.com/display/en/Forms)
* [German](https://kb.i-doit.com/display/de/Forms)

## System Requirements

* i-doit Version >= v1.18
* MongoDB Server v5
* NodeJS >= v16.x

## Installation

### Installation steps

1. Install Forms Add-on via [Admin center](https://kb.i-doit.com/display/de/Admin+Center)
2. Install [the MongoDB Server v5](https://docs.mongodb.com/manual/installation/)
3. Install [NodeJS >= v16](https://nodejs.org/en/download/current/) via [Package manager](https://nodejs.org/en/download/package-manager/)
4. Configure the Forms Backend
5. Configure the connection to your Forms Backend in i-doit

### Configuration of the Forms Backend

1. Navigate to the Forms Backend sub folder: `cd src/classes/modules/forms/backend/`
2. Create configuration from template: `cp .env.dist .env`
3. Adjust configuration: `vim .env` or `nano .env` or using any text editor

   `FORMS_SECRET` - is an application secret which is used to secure the data stored in the db

   `FORMS_PORT` - port to accept connections. By default, it's `3000`

   `FORMS_MONGO_DB_SERVER` - connection url of the MongoDB server. By default, it's `mongodb://127.0.0.1:27017/forms`

4. Run inside the backend folder `src/classes/modules/forms/backend/` the following command `./run.sh instance:create {username} {apikey}` with some `username` and `apikey` to set up an instance.
   You will need to set these credentials in i-doit Settings to authorize i-doit against the Forms Backend.
   E.g:  `./run.sh instance:create testuser testapikey`
5. Run `./run.sh` to start the server

The backend server has to run permanently. You can register it as a service via systemd by running
```
sudo chmod +x forms-service.sh
sudo ./forms-service.sh
```

### Configure Forms Add-on in Tenant Settings -> Forms Add-on

In order for the frontend to be able to communicate with the backend, we have to enter the previously used username and the API key under System Settings Tenant Settings Forms Add-on.
