"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListCommand = void 0;
const common_1 = require("@nestjs/common");
const console_1 = require("../../console");
const console_service_1 = require("../console.service");
let ListCommand = class ListCommand extends console_1.CommandInterface {
    constructor(service) {
        super();
        this.service = service;
    }
    async execute() {
        this.log('Available commands:\n');
        for (const id in this.service.commands) {
            const [command] = this.service.commands[id];
            this.log('\n--------------------');
            const parameters = command.parameters || [];
            const usage = parameters.reduce((result, parameter) => `${result} {${parameter.name}}`, `./run.sh ${command.name}`);
            this.log(usage);
            for (const parameter of parameters) {
                this.log(`{${parameter.name}} - ${parameter.description}`);
            }
            this.log(' ');
            this.log(command.description);
        }
        return 0;
    }
};
ListCommand = __decorate([
    (0, common_1.Injectable)(),
    (0, console_1.Command)('list', 'Show available commands'),
    __metadata("design:paramtypes", [console_service_1.ConsoleService])
], ListCommand);
exports.ListCommand = ListCommand;
//# sourceMappingURL=list.command.js.map