"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ConsoleExplorer_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleExplorer = void 0;
const core_1 = require("@nestjs/core");
const common_1 = require("@nestjs/common");
const console_decorator_1 = require("./console.decorator");
const console_interface_1 = require("./console.interface");
let ConsoleExplorer = ConsoleExplorer_1 = class ConsoleExplorer {
    constructor(container) {
        this.container = container;
    }
    explore() {
        return [...this.container.values()]
            .reduce((result, module) => [...module.providers.entries()].reduce((r, [token, instance]) => {
            const meta = ConsoleExplorer_1.extractMetadata(instance.instance, console_interface_1.ConsoleMetaKey);
            if (meta) {
                return [
                    ...r,
                    [meta, token],
                ];
            }
            return r;
        }, result), []);
    }
    static extractMetadata(instance, metadataKey) {
        if (!instance || !instance.constructor) {
            return;
        }
        const metadata = Reflect.getMetadata(metadataKey, instance.constructor);
        if ((0, console_decorator_1.isCommandInfo)(metadata)) {
            return metadata;
        }
        return undefined;
    }
};
ConsoleExplorer = ConsoleExplorer_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [core_1.ModulesContainer])
], ConsoleExplorer);
exports.ConsoleExplorer = ConsoleExplorer;
//# sourceMappingURL=console.explorer.js.map