import { FormAccessService } from '../forms/form-access.service';
import { FormDataService } from './form-data.service';
import { CreateFormDataDto } from './dto/create-form-data.dto';
import { UpdateFormDataDto } from './dto/update-form-data.dto';
import { FindFormDataDto } from './dto/find-form-data.dto';
import { FormData } from './schemas/form-data.schema';
import { SearchResult } from './schemas/SearchResult';
export declare class FormDataController {
    private readonly formsService;
    private readonly accessService;
    constructor(formsService: FormDataService, accessService: FormAccessService);
    checkAccess(id: string): Promise<void>;
    create(createFormDto: CreateFormDataDto): Promise<FormData>;
    findAll(find: FindFormDataDto): Promise<SearchResult<FormData>>;
    findOne(id: string): Promise<FormData>;
    update(id: string, updateFormDto: UpdateFormDataDto): Promise<FormData>;
    remove(id: string): Promise<FormData>;
}
