"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConfig = exports.isFormNode = void 0;
const isConfig = (obj) => {
    if (typeof obj !== 'object') {
        return false;
    }
    return typeof obj.type === 'string' && (!Object.prototype.hasOwnProperty.call(obj, 'props') || typeof obj.props === 'object');
};
exports.isConfig = isConfig;
const isFormNode = (obj) => {
    if (typeof obj !== 'object') {
        return false;
    }
    if (Object.prototype.hasOwnProperty.call(obj, 'children') && !Array.isArray(obj.children)) {
        return false;
    }
    return isConfig(obj.config);
};
exports.isFormNode = isFormNode;
//# sourceMappingURL=FormNode.js.map