"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormSchema = exports.Form = void 0;
const mongoose_1 = require("@nestjs/mongoose");
const mongoose = require("mongoose");
const FormNode_1 = require("./FormNode");
let Form = class Form {
};
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", String)
], Form.prototype, "name", void 0);
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", Date)
], Form.prototype, "created", void 0);
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", Date)
], Form.prototype, "updated", void 0);
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", Boolean)
], Form.prototype, "published", void 0);
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", String)
], Form.prototype, "identifier", void 0);
__decorate([
    (0, mongoose_1.Prop)(),
    __metadata("design:type", String)
], Form.prototype, "instance", void 0);
__decorate([
    (0, mongoose_1.Prop)({
        type: mongoose.Schema.Types.Map,
        validate: (obj) => {
            if (typeof obj !== 'object') {
                const err = new mongoose.Error('Invalid shape of the form');
                throw new mongoose.Error.ValidationError(err);
            }
            obj.forEach((node, key) => {
                if (!(0, FormNode_1.isFormNode)(node)) {
                    const err = new mongoose.Error(`Invalid shape of the form node ${key}`);
                    throw new mongoose.Error.ValidationError(err);
                }
            });
        },
    }),
    __metadata("design:type", Object)
], Form.prototype, "shape", void 0);
__decorate([
    (0, mongoose_1.Prop)({ type: [{ type: mongoose.Schema.Types.ObjectId, ref: 'FormData' }] }),
    __metadata("design:type", Array)
], Form.prototype, "data", void 0);
Form = __decorate([
    (0, mongoose_1.Schema)()
], Form);
exports.Form = Form;
exports.FormSchema = mongoose_1.SchemaFactory.createForClass(Form);
//# sourceMappingURL=form.schema.js.map