import { SearchResult } from "../forms/schemas/SearchResult";
import { InstanceService } from './instance.service';
import { CreateInstanceDto } from './dto/create-instance.dto';
import { UpdateInstanceDto } from './dto/update-instance.dto';
import { Instance } from './schemas/instance.schema';
import { FindInstanceDto } from './dto/find-instance.dto';
export declare class InstanceController {
    private readonly instanceService;
    constructor(instanceService: InstanceService);
    create(createInstanceDto: CreateInstanceDto): Promise<Instance>;
    findAll(find: FindInstanceDto): Promise<SearchResult<Instance>>;
    findOneByName(name: string, apikey: string): Promise<Instance>;
    findOne(id: string): Promise<Instance>;
    update(id: string, updateInstanceDto: UpdateInstanceDto): Promise<Instance>;
    remove(id: string): Promise<Instance>;
}
