"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceController = void 0;
const common_1 = require("@nestjs/common");
const local_auth_guard_1 = require("../auth/guards/local-auth.guard");
const public_1 = require("../utils/public");
const instance_service_1 = require("./instance.service");
const create_instance_dto_1 = require("./dto/create-instance.dto");
const update_instance_dto_1 = require("./dto/update-instance.dto");
const find_instance_dto_1 = require("./dto/find-instance.dto");
const ObjectIdPipe_1 = require("../utils/ObjectIdPipe");
let InstanceController = class InstanceController {
    constructor(instanceService) {
        this.instanceService = instanceService;
    }
    create(createInstanceDto) {
        return this.instanceService.create(createInstanceDto);
    }
    findAll(find) {
        return this.instanceService.findAll(find);
    }
    findOneByName(name, apikey) {
        return this.instanceService.findOneByNameAndKey(name, apikey);
    }
    findOne(id) {
        return this.instanceService.findOne(id);
    }
    update(id, updateInstanceDto) {
        return this.instanceService.update(id, updateInstanceDto);
    }
    remove(id) {
        return this.instanceService.remove(id);
    }
};
__decorate([
    (0, public_1.Public)(),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_instance_dto_1.CreateInstanceDto]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [find_instance_dto_1.FindInstanceDto]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "findAll", null);
__decorate([
    (0, public_1.Public)(),
    (0, common_1.UseGuards)(local_auth_guard_1.LocalAuthGuard),
    (0, common_1.Get)(':name/:apikey'),
    __param(0, (0, common_1.Param)('name')),
    __param(1, (0, common_1.Param)('apikey')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "findOneByName", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_instance_dto_1.UpdateInstanceDto]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id', ObjectIdPipe_1.ObjectIdPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], InstanceController.prototype, "remove", null);
InstanceController = __decorate([
    (0, common_1.Controller)('api/instance'),
    __metadata("design:paramtypes", [instance_service_1.InstanceService])
], InstanceController);
exports.InstanceController = InstanceController;
//# sourceMappingURL=instance.controller.js.map