import { Model } from 'mongoose';
import { SearchResult } from '../forms/schemas/SearchResult';
import { CreateInstanceDto } from './dto/create-instance.dto';
import { UpdateInstanceDto } from './dto/update-instance.dto';
import { Instance, InstanceType } from "./schemas/instance.schema";
import { FindInstanceDto } from './dto/find-instance.dto';
export declare class InstanceService {
    private instanceModel;
    constructor(instanceModel: Model<InstanceType>);
    create(createInstanceDto: CreateInstanceDto): Promise<Instance>;
    findAll(find: FindInstanceDto): Promise<SearchResult<Instance>>;
    findOne(id: string): Promise<Instance>;
    findOneByNameAndKey(name: string, apikey: string): Promise<Instance>;
    update(id: string, updateInstanceDto: UpdateInstanceDto): Promise<Instance>;
    remove(id: string): Promise<Instance>;
}
