"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const common_1 = require("@nestjs/common");
const app_module_1 = require("./app.module");
const console_service_1 = require("./console/console.service");
async function bootstrap() {
    var _a;
    const options = {};
    const app = await core_1.NestFactory.create(app_module_1.AppModule, options);
    const port = parseInt(process.env.FORMS_PORT || '3000', 10);
    app.useGlobalPipes(new common_1.ValidationPipe({ transform: true }));
    await app.init();
    const command = (_a = process.argv[2]) !== null && _a !== void 0 ? _a : null;
    if (command) {
        const service = app.get(console_service_1.ConsoleService);
        await service.execute(command);
        await app.close();
        return;
    }
    await app.listen(port);
}
void bootstrap();
//# sourceMappingURL=main.js.map