declare type FieldType = {
    field: string;
};
declare type EqType = FieldType & {
    operation: 'eq';
    value: string | number | boolean;
};
declare type BetweenType = FieldType & RangeType & {
    operation: 'between';
};
declare type LikeType = FieldType & {
    operation: 'like';
    value: string;
};
declare type InType = FieldType & {
    operation: 'in';
    value: string[] | number[];
};
declare type RangeType = {
    from?: number | Date;
    to?: number | Date;
};
declare const isArrayWithType: (value: unknown[], checkType: string) => value is string[] & number[];
declare const isFilter: (filter: unknown) => filter is EqType | BetweenType | LikeType | InType;
declare const eqOperator: (field: string, value: string | number | boolean) => Record<string, string | number | boolean>;
declare const betweenOperator: (field: string, from: number | Date, to: number | Date) => Record<string, {
    $gte: number | Date;
    $lte: number | Date;
}>;
declare const likeOperator: (field: string, value: string) => Record<string, {
    $regex: RegExp;
    $options: string;
}>;
declare const inOperator: (field: string, value: string[] | number[]) => Record<string, {
    $in: string[] | number[];
}>;
declare const filterConverter: (filter: Record<string, unknown>[]) => Record<string, unknown>;
declare const convertToFilter: (data: Record<string, unknown>) => Record<string, string | number | boolean> | Record<string, {
    $gte: number | Date;
    $lte: number | Date;
}> | Record<string, {
    $regex: RegExp;
    $options: string;
}> | Record<string, {
    $in: string[] | number[];
}>;
export { filterConverter, convertToFilter, isFilter, isArrayWithType, eqOperator, betweenOperator, likeOperator, inOperator };
