import { Type } from '@nestjs/common';
import { ModuleRef } from '@nestjs/core';
import 'reflect-metadata';
import { IQuery, IQueryBus, IQueryHandler, IQueryPublisher, IQueryResult } from './interfaces';
import { ObservableBus } from './utils/observable-bus';
export declare type QueryHandlerType<QueryBase extends IQuery = IQuery, QueryResultBase extends IQueryResult = IQueryResult> = Type<IQueryHandler<QueryBase, QueryResultBase>>;
export declare class QueryBus<QueryBase extends IQuery = IQuery> extends ObservableBus<QueryBase> implements IQueryBus<QueryBase> {
    private readonly moduleRef;
    private handlers;
    private _publisher;
    constructor(moduleRef: ModuleRef);
    get publisher(): IQueryPublisher<QueryBase>;
    set publisher(_publisher: IQueryPublisher<QueryBase>);
    execute<T extends QueryBase, TResult = any>(query: T): Promise<TResult>;
    bind<T extends QueryBase, TResult = any>(handler: IQueryHandler<T, TResult>, queryId: string): void;
    register(handlers?: QueryHandlerType<QueryBase>[]): void;
    protected registerHandler(handler: QueryHandlerType<QueryBase>): void;
    private getQueryId;
    private reflectQueryId;
    private useDefaultPublisher;
}
