import { Type } from '@nestjs/common';
import { InstanceWrapper } from '@nestjs/core/injector/instance-wrapper';
import { Module } from '@nestjs/core/injector/module';
import { ModulesContainer } from '@nestjs/core/injector/modules-container';
import { IEvent } from '../interfaces';
import { CqrsOptions } from '../interfaces/cqrs-options.interface';
export declare class ExplorerService<EventBase extends IEvent = IEvent> {
    private readonly modulesContainer;
    constructor(modulesContainer: ModulesContainer);
    explore(): CqrsOptions;
    flatMap<T>(modules: Module[], callback: (instance: InstanceWrapper) => Type<any> | undefined): Type<T>[];
    filterProvider(wrapper: InstanceWrapper, metadataKey: string): Type<any> | undefined;
    extractMetadata(instance: Record<string, any>, metadataKey: string): Type<any>;
}
