"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("@nestjs/common");
const jwt = require("jsonwebtoken");
const jwt_module_options_interface_1 = require("./interfaces/jwt-module-options.interface");
const jwt_constants_1 = require("./jwt.constants");
let JwtService = class JwtService {
    constructor(options) {
        this.options = options;
        this.logger = new common_1.Logger('JwtService');
    }
    sign(payload, options) {
        const signOptions = this.mergeJwtOptions(Object.assign({}, options), 'signOptions');
        const secret = this.getSecretKey(payload, options, 'privateKey', jwt_module_options_interface_1.JwtSecretRequestType.SIGN);
        return jwt.sign(payload, secret, signOptions);
    }
    signAsync(payload, options) {
        const signOptions = this.mergeJwtOptions(Object.assign({}, options), 'signOptions');
        const secret = this.getSecretKey(payload, options, 'privateKey', jwt_module_options_interface_1.JwtSecretRequestType.SIGN);
        return new Promise((resolve, reject) => jwt.sign(payload, secret, signOptions, (err, encoded) => err ? reject(err) : resolve(encoded)));
    }
    verify(token, options) {
        const verifyOptions = this.mergeJwtOptions(Object.assign({}, options), 'verifyOptions');
        const secret = this.getSecretKey(token, options, 'publicKey', jwt_module_options_interface_1.JwtSecretRequestType.VERIFY);
        return jwt.verify(token, secret, verifyOptions);
    }
    verifyAsync(token, options) {
        const verifyOptions = this.mergeJwtOptions(Object.assign({}, options), 'verifyOptions');
        const secret = this.getSecretKey(token, options, 'publicKey', jwt_module_options_interface_1.JwtSecretRequestType.VERIFY);
        return new Promise((resolve, reject) => jwt.verify(token, secret, verifyOptions, (err, decoded) => err ? reject(err) : resolve(decoded)));
    }
    decode(token, options) {
        return jwt.decode(token, options);
    }
    mergeJwtOptions(options, key) {
        delete options.secret;
        if (key === 'signOptions') {
            delete options.privateKey;
        }
        else {
            delete options.publicKey;
        }
        return options
            ? Object.assign(Object.assign({}, (this.options[key] || {})), options) : this.options[key];
    }
    getSecretKey(token, options, key, secretRequestType) {
        var _a, _b;
        let secret = this.options.secretOrKeyProvider
            ? this.options.secretOrKeyProvider(secretRequestType, token, options)
            : (options === null || options === void 0 ? void 0 : options.secret) ||
                this.options.secret ||
                (key === 'privateKey'
                    ? ((_a = options) === null || _a === void 0 ? void 0 : _a.privateKey) || this.options.privateKey
                    : ((_b = options) === null || _b === void 0 ? void 0 : _b.publicKey) ||
                        this.options.publicKey) ||
                this.options[key];
        if (this.options.secretOrPrivateKey) {
            this.logger.warn(`"secretOrPrivateKey" has been deprecated, please use the new explicit "secret" or use "secretOrKeyProvider" or "privateKey"/"publicKey" exclusively.`);
            secret = this.options.secretOrPrivateKey;
        }
        return secret;
    }
};
JwtService = __decorate([
    common_1.Injectable(),
    __param(0, common_1.Inject(jwt_constants_1.JWT_MODULE_OPTIONS)),
    __metadata("design:paramtypes", [Object])
], JwtService);
exports.JwtService = JwtService;
