import { ModuleMetadata, Type } from '@nestjs/common';
import { ConnectOptions } from 'mongoose';
export interface MongooseModuleOptions extends ConnectOptions, Record<string, any> {
    uri?: string;
    retryAttempts?: number;
    retryDelay?: number;
    connectionName?: string;
    connectionFactory?: (connection: any, name: string) => any;
}
export interface MongooseOptionsFactory {
    createMongooseOptions(): Promise<MongooseModuleOptions> | MongooseModuleOptions;
}
export interface MongooseModuleAsyncOptions extends Pick<ModuleMetadata, 'imports'> {
    connectionName?: string;
    useExisting?: Type<MongooseOptionsFactory>;
    useClass?: Type<MongooseOptionsFactory>;
    useFactory?: (...args: any[]) => Promise<MongooseModuleOptions> | MongooseModuleOptions;
    inject?: any[];
}
