import { RequestMethod } from '@nestjs/common';
import { VersioningOptions, VersionValue } from '@nestjs/common/interfaces';
import { CorsOptions, CorsOptionsDelegate } from '@nestjs/common/interfaces/external/cors-options.interface';
import { NestApplicationOptions } from '@nestjs/common/interfaces/nest-application-options.interface';
import { AbstractHttpAdapter } from '@nestjs/core/adapters/http-adapter';
import { ServeStaticOptions } from '../interfaces/serve-static-options.interface';
export declare class ExpressAdapter extends AbstractHttpAdapter {
    private readonly routerMethodFactory;
    constructor(instance?: any);
    reply(response: any, body: any, statusCode?: number): any;
    status(response: any, statusCode: number): any;
    render(response: any, view: string, options: any): any;
    redirect(response: any, statusCode: number, url: string): any;
    setErrorHandler(handler: Function, prefix?: string): any;
    setNotFoundHandler(handler: Function, prefix?: string): any;
    setHeader(response: any, name: string, value: string): any;
    listen(port: string | number, callback?: () => void): any;
    listen(port: string | number, hostname: string, callback?: () => void): any;
    close(): Promise<unknown>;
    set(...args: any[]): any;
    enable(...args: any[]): any;
    disable(...args: any[]): any;
    engine(...args: any[]): any;
    useStaticAssets(path: string, options: ServeStaticOptions): any;
    setBaseViewsDir(path: string | string[]): any;
    setViewEngine(engine: string): any;
    getRequestHostname(request: any): string;
    getRequestMethod(request: any): string;
    getRequestUrl(request: any): string;
    enableCors(options: CorsOptions | CorsOptionsDelegate<any>): any;
    createMiddlewareFactory(requestMethod: RequestMethod): (path: string, callback: Function) => any;
    initHttpServer(options: NestApplicationOptions): void;
    registerParserMiddleware(): void;
    setLocal(key: string, value: any): this;
    getType(): string;
    applyVersionFilter(handler: Function, version: VersionValue, versioningOptions: VersioningOptions): <TRequest extends Record<string, any> = any, TResponse = any>(req: TRequest, res: TResponse, next: () => void) => any;
    private isMiddlewareApplied;
}
