<?php
/**
 * i-doit
 *
 * Add-on forms init.php
 *
 * @package     forms add-on
 * @copyright   synetics
 * @license
 */

use idoit\Psr4AutoloaderClass;

if (isys_module_manager::instance()
  ->is_active('forms')) {
  Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\Forms', __DIR__ . '/src/');

  include_once __DIR__ . '/isys_module_forms_autoload.class.php';

  spl_autoload_register('isys_module_forms_autoload::init');

  // Register Route
  isys_request_controller::instance()
    ->addModuleRoute('POST', '/forms/api/formdata', 'forms', 'ApplyData', 'execute')
    ->addModuleRoute('GET', '/forms/api/data/[**:attributeId]', 'forms', 'DataApi', 'getDataByAttribute')
    ->addModuleRoute('GET', '/forms/api/class', 'forms', 'DataApi', 'getClasses')
    ->addModuleRoute('GET', '/forms/api/category', 'forms', 'DataApi', 'getCategories')
    ->addModuleRoute('GET', '/forms/api/attribute', 'forms', 'DataApi', 'getAttributes')
    ->addModuleRoute('GET', '/forms/api/user', 'forms', 'UserApi', 'getUsers')
    ->addModuleRoute('GET', '/forms/api/tree', 'forms', 'DataApi', 'getLocationTree')
    ->addModuleRoute('GET|POST|DELETE|PUT|PATCH', '/forms/api/[**:path]', 'forms', 'Api')
    ->addModuleRoute('GET', '/forms/form', 'forms', 'Form')
    ->addModuleRoute('GET|POST', '/forms/form/[**:id]', 'forms', 'Form', 'page')
    ->addModuleRoute('GET|POST', '/forms/[**:id]', 'forms', 'Publish');

  // Get component registry
  if ($registry = isys_application::instance()->container->get('components.registry')) {
    // Register api provided react components
    $registry->register('menu_tree.config.forms.showMenu', false);
    $registry->register('idoit.addon.forms',
      isys_application::instance()->www_path . 'src/classes/modules/forms/react/dist/index.min.js');
  }

  $language = isys_application::instance()->container->get('language');

  isys_tenantsettings::extend([
    'Forms Add-on' => [
      'forms.backend.api.url' => [
        'title'   => 'LC__MODULE__FORMS__SETTINGS_API_URL',
        'type'    => 'text',
        'default' => 'http://127.0.0.1:3000',
        'description' => 'LC__MODULE__FORMS__SETTINGS_API_URL_DESCRIPTION'
      ],
      'forms.backend.api.apiname' => [
        'title'   => 'LC__MODULE__FORMS__SETTINGS_API_NAME',
        'type'    => 'text',
        'default' => '',
        'description' => 'LC__MODULE__FORMS__SETTINGS_API_NAME_DESCRIPTION'
      ],
      'forms.backend.api.apikey'  => [
        'title'   => 'LC__MODULE__FORMS__SETTINGS_API_KEY',
        'type'    => 'password',
        'default' => '',
        'description' => 'LC__MODULE__FORMS__SETTINGS_API_KEY_DESCRIPTION'
      ],
    ]
  ]);
}
