<?php

use idoit\AddOn\ActivatableInterface;
use idoit\AddOn\AuthableInterface;
use idoit\AddOn\InstallableInterface;
use idoit\AddOn\LicensableInterface;
use idoit\Exception\JsonException;
use idoit\Module\Forms\Processor;
use idoit\Module\Forms\Processor\Activate;
use idoit\Module\Forms\Processor\Deactivate;
use idoit\Module\Forms\Processor\Install;
use idoit\Module\Forms\Processor\Uninstall;
use idoit\Module\Forms\Processor\Update;

/**
 * i-doit
 *
 * Add-on forms module class.
 *
 * @package   forms
 * @copyright synetics
 * @license
 */
class isys_module_forms extends isys_module implements InstallableInterface, ActivatableInterface, AuthableInterface, LicensableInterface
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = true;

    /**
     * @var bool
     */
    protected static $m_licenced = false;

    /**
     * @return void
     */
    public function start()
    {
    }

    /**
     * @return isys_auth_forms
     */
    public static function getAuth()
    {
        return isys_auth_forms::instance();
    }

    /**
     * Initializes the module.
     *
     * @param isys_module_request $p_req
     */
    public function init(isys_module_request $p_req)
    {
        return $this;
    }

    /**
     * Checks if a add-on is installed.
     *
     * @return int|bool
     */
    public static function isInstalled()
    {
        return isys_module_manager::instance()->is_installed('forms');
    }

    /**
     * Basic installation process for all mandators.
     *
     * @param isys_component_database $tenantDatabase
     * @param isys_component_database $systemDatabase
     * @param int                     $moduleId
     * @param string                  $type
     * @param int                     $tenantId
     *
     * @return bool
     * @throws JsonException
     * @throws isys_exception_dao
     * @throws isys_exception_database
     */
    public static function install($tenantDatabase, $systemDatabase, $moduleId, $type, $tenantId)
    {
        // Dummy autoloader for the admin-center.
        if (!class_exists(Processor::class)) {
            include_once __DIR__ . '/src/Processor.php';
        }

        if ($type === 'install') {
            if (!class_exists(Install::class)) {
                include_once __DIR__ . '/src/Processor/Install.php';
            }

            (new Install($tenantDatabase, (int)$tenantId))->process();
        }

        if (!class_exists(Update::class)) {
            include_once __DIR__ . '/src/Processor/Update.php';
        }

        (new Update($tenantDatabase, (int)$tenantId))->process();

        return true;
    }

    /**
     * Uninstall add-on for all mandators.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return boolean
     * @throws JsonException
     * @throws isys_exception_dao
     */
    public static function uninstall($tenantDatabase)
    {
        // Dummy autoloader for the admin-center.
        if (!class_exists(Processor::class)) {
            include_once __DIR__ . '/src/Processor.php';
        }

        if (!class_exists(Uninstall::class)) {
            include_once __DIR__ . '/src/Processor/Uninstall.php';
        }

        (new Uninstall($tenantDatabase))->process();

        return true;
    }

    /**
     * Checks if a add-on is active.
     *
     * @return integer|bool
     */
    public static function isActive()
    {
        return isys_module_manager::instance()->is_installed('forms', true);
    }

    /**
     * Method that is called after clicking "activate" in admin center for specific mandator.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return boolean
     * @throws JsonException
     * @throws isys_exception_dao
     */
    public static function activate($tenantDatabase)
    {
        // Dummy autoloader for the admin-center.
        if (!class_exists(Processor::class)) {
            include_once __DIR__ . '/src/Processor.php';
        }

        if (!class_exists(Activate::class)) {
            include_once __DIR__ . '/src/Processor/Activate.php';
        }

        (new Activate($tenantDatabase))->process();

        return true;
    }

    /**
     * Method that is called after clicking "deactivate" in admin center for specific mandator.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return boolean
     * @throws isys_exception_dao
     * @throws JsonException
     */
    public static function deactivate($tenantDatabase)
    {
        // Dummy autoloader for the admin-center.
        if (!class_exists(Processor::class)) {
            include_once __DIR__ . '/src/Processor.php';
        }

        if (!class_exists(Deactivate::class)) {
            include_once __DIR__ . '/src/Processor/Deactivate.php';
        }

        (new Deactivate($tenantDatabase))->process();

        return true;
    }

    /**
     * @return bool
     */
    public static function isLicensed()
    {
        return static::$m_licenced;
    }

    /**
     * @param bool $isLicensed
     *
     * @return void
     */
    public static function setLicensed($isLicensed)
    {
        static::$m_licenced = $isLicensed;
    }
}
