<?php

namespace idoit\Module\Forms\Controller;

use idoit;
use idoit\Controller\Base;
use isys_application as Application;
use isys_component_tree;
use isys_controller as Controller;
use isys_module;
use isys_register as Register;
use idoit\Module\Forms\Proxy\RequestProxy;

class Api extends Base implements Controller
{
    public function __construct(isys_module $p_module) { }

    public function dao(Application $p_application)
    {
        // TODO: Implement dao() method.
    }

    public function handle(Register $p_request, Application $p_application)
    {
      $session = $p_application->container->get('session');
      $proxy = new RequestProxy($session);
      $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
      $method = $method === 'PUT' ? 'PATCH' : $method;
      $body = file_get_contents('php://input');
      $parts = [];

      foreach ($p_request->get('GET') as $key => $value) {
        $parts[] = "$key=$value";
      }

      $url = implode('?', [
        $p_request->get('path'),
        implode('&', $parts)
      ]);

      $response = $proxy->proxy($method, $url, $body);
      http_response_code($response->getStatusCode());
      header('Content-Type: ' . $response->getHeader('Content-Type'));
      echo $response->getBody()->getContents();
      exit;
    }

    public function tree(Register $p_request, Application $p_application, isys_component_tree $p_tree)
    {
        // TODO: Implement tree() method.
    }
}
