<?php

namespace idoit\Module\Forms\Controller;

use Exception;
use idoit\Controller\Base;
use idoit\Module\Forms\Model\Dao;
use idoit\Module\Forms\View\Main as MainView;
use idoit\Tree\Node as TreeNode;
use idoit\View\ReactRenderable;
use isys_application as Application;
use isys_module as Module;
use isys_controller as Controller;
use isys_register as Request;
use isys_component_tree as Tree;

class Main extends Base implements Controller
{
    /**
     * @var Module
     */
    protected $module;

    /**
     * @param Module $module
     */
    public function __construct(Module $module) {
        $this->module = $module;
    }

    /**
     * @param   Application $application
     *
     * @return  Dao
     * @throws  Exception
     */
    public function dao(Application $application)
    {
        return Dao::instance($this->getDi()->get('database'));
    }

    /**
     * @param Request     $request
     * @param Application $application
     *
     * @return MainView
     */
    public function handle(Request $request, Application $application)
    {
        return new MainView($request, 'idoit.addon.forms.Page', []);
    }

    /**
     * @param Request     $request
     * @param Application $application
     * @param Tree        $tree
     *
     * @return TreeNode|void
     */
    public function tree(Request $request, Application $application, Tree $tree)
    {
        // No tree defined
    }
}