<?php

namespace idoit\Module\Forms\Controller;

use idoit;
use idoit\Component\ClassLoader\ModuleLoader;
use idoit\Controller\Base;
use idoit\Module\Forms\Model\UserDao;
use isys_application as Application;
use isys_component_database_proxy;
use isys_component_template_language_manager;
use isys_component_tree;
use isys_controller as Controller;
use isys_module;
use isys_register as Register;

class UserApi extends Base implements Controller
{
  /**
   * @var string|array|null
   */
  protected $response = null;
  /**
   * @var isys_component_database_proxy
   */
  private $database;
  /**
   * @var isys_component_template_language_manager
   */
  private $language;

  /**
   * @param isys_module $p_module
   *
   * @throws \Exception
   */
  public function __construct(isys_module $p_module)
  {
    $this->database = $this->getDi()->get('database');
    $this->language = $this->getDi()->get('language');
  }

  public function pre(): void
  {
    header('Content-Type: application/json; charset=UTF-8');
  }

  public function post(): void
  {
    echo json_encode($this->response);
    exit;
  }

  public function dao(Application $application)
  {
    // Nothing to do here.
  }

  public function handle(Register $request, Application $application)
  {
    // Nothing to do here.
  }

  public function tree(Register $request, Application $application, isys_component_tree $tree)
  {
    // Nothing to do here.
  }

  /**
   * @param Register $request
   * @param ModuleLoader $moduleLoader
   *
   * @throws \Exception
   */
  public function getUsers(Register $request, ModuleLoader $moduleLoader): void
  {
    $this->response = [];
    $result = UserDao::instance($this->database)->getAll();

    while ($row = $result->get_row()) {
      $this->response[] = [
        'id' => $row['id'],
        'name' => $this->language->get($row['title']),
      ];
    }
  }
}
