<?php

namespace idoit\Module\Forms\Model\Processors;

use idoit\Module\Forms\Model\Processors\Interfaces\PreSyncModifierInterface;

class AccountingProcessor extends AbstractProcessor implements PreSyncModifierInterface
{
  protected static $categoryConst = 'C__CATG__ACCOUNTING';

  /**
   * @param array $syncData
   * @param int   $objectId
   *
   * @return array
   */
  public function preSyncModify(array $syncData, int $objectId): array
  {
    if (isset($syncData['properties']['contact'][C__DATA__VALUE])
      && is_numeric($syncData['properties']['contact'][C__DATA__VALUE])
    ) {
      $syncData['properties']['contact'][C__DATA__VALUE] = [$syncData['properties']['contact'][C__DATA__VALUE]];
    }
    return $syncData;
  }
}
