<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Forms\Model\Processors;

use idoit\Module\Forms\Model\Processors\Interfaces\PreSyncModifierInterface;

/**
 * SoftwareAssignmentProcessor
 *
 * @package    idoit\Module\Api\Model\Category
 */
class ApplicationProcessor extends AbstractProcessor implements PreSyncModifierInterface
{
    /**
     * @var string
     */
    protected static $categoryConst = 'C__CATG__APPLICATION';

    /**
     * Modify sync data
     *
     * @param array $syncData
     * @param int $objectId
     *
     * @return array
     */
    public function preSyncModify(array $syncData, int $objectId): array
    {
      if (!array_key_exists('assigned_database_schema', $syncData['properties'])) {
          $syncData['properties']['assigned_database_schema'] = null;
      }

      return $syncData;
    }
}
