<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Forms\Model\Processors;

use idoit\Module\Forms\Model\Processors\Interfaces\PreMergeModifierInterface;
use idoit\Module\Forms\Model\Processors\Interfaces\PreSyncModifierInterface;

/**
 * IpProcessor
 */
class Ipv6Processor extends AbstractProcessor implements PreSyncModifierInterface,PreMergeModifierInterface
{
    /**
     * @var string
     */
    protected static $categoryConst = 'C__CATG__IP__IPV6';

    /**
     * Modify sync data
     *
     * @param array $syncData
     * @param int $objectId
     *
     * @return array
     */
    public function preSyncModify(array $syncData, int $objectId): array
    {
        /**
         * @see API-282 The property should contain a 'yes' or 'no' value, depending on if it's the default gateway.
         */
        if (!array_key_exists('use_standard_gateway', $syncData['properties'])) {
            $syncData['properties']['use_standard_gateway'][C__DATA__VALUE] = 0;
        }

        return $syncData;
    }

    /**
     * @param array $data
     * @param int   $objectId
     *
     * @return array
     */
    public function preMergeModify(array $data, int $objectId): array
    {
        if (!isset($data['properties']['net_type'][C__DATA__VALUE])) {
            $data['properties']['net_type'][C__DATA__VALUE] = defined_or_default('C__CATS_NET_TYPE__IPV6', 1000);
        }

        if (!isset($data['properties']['net'][C__DATA__VALUE])) {
            $data['properties']['net'][C__DATA__VALUE] = defined_or_default('C__OBJ__NET_GLOBAL_IPV6', 21);
        }

        return $data;
    }
}
