<?php

namespace idoit\Module\Forms\Model\Validators\Category;

use Exception;
use isys_application;
use isys_component_template_language_manager;

abstract class AbstractCategoryValidator
{
  public const CATEGORY_CONST = '';

  /**
   * @var isys_component_template_language_manager
   */
  public $language = null;

  /**
   * @param string $categoryConst
   *
   * @return bool
   */
  public function isApplicable(string $categoryConst): bool
  {
    return $categoryConst === static::CATEGORY_CONST;
  }

  /**
   * @return static
   * @throws Exception
   */
  public static function factory()
  {
    $object = new static();
    $object->language = isys_application::instance()->container->get('language');
    return $object;
  }
}
