<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * Application controller
 *
 * @package    i-doit
 * @subpackage General
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
$app                = isys_application::instance();
$catchallController = \idoit\Controller\CatchallController::factory($app->container);

$app->run(
    isys_request_controller::instance()
        ->route(
            'GET|POST',
            '/[s:module]/[s:action]/[c:method]/[i:id]',
            [
                $catchallController,
                'handle'
            ]
        )
        ->route(
            'GET|POST',
            '/[s:module]/[s:action]/[c:method]',
            [
                $catchallController,
                'handle'
            ]
        )
        ->route(
            'GET|POST',
            '/[s:module]?/[s:action]?/[i:id]?',
            [
                $catchallController,
                'handle'
            ]
        )
);