<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * Settings DAO.
 *
 * @package     i-doit
 * @subpackage  Components
 * @author      Dennis Stücken <dstuecken@i-doit.de>
 * @version     1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
abstract class isys_component_dao_abstract_settings extends isys_component_dao
{
    /**
     * @var array
     */
    protected $m_cached_settings = null;

    /**
     * @param $p_key
     * @param $p_value
     *
     * @return mixed
     */
    abstract public function set($p_key, $p_value);

    /**
     * Remove setting
     *
     * @param $p_key
     *
     * @return mixed
     */
    abstract public function remove($p_key);

    /**
     * Save settings.
     *
     * @param   array   $p_settings
     *
     * @return  boolean
     */
    public function save($p_settings)
    {
        if (is_array($p_settings) && count($p_settings) > 0)
        {
            $this->begin_update();

            foreach ($p_settings as $l_key => $l_value)
            {
                if ($l_key)
                {
                    if ($l_value === true)
                    {
                        $l_value = '1';
                    } // if

                    if ($l_value === false)
                    {
                        $l_value = '0';
                    } // if

                    $this->set($l_key, $l_value);
                } // if
            } // foreach

            return $this->apply_update();
        } // if

        return false;
    } // function
} // class