<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * Builds html-table for the object lists.
 *
 * @package     i-doit
 * @subpackage  Components
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_component_table_csv extends isys_component_list_csv
{
    /**
     * Creates the temporary table with the data from init.
     *
     * @return  boolean
     */
    public function createTempTable()
    {
        $l_csv = \League\Csv\Writer::createFromFileObject(new SplTempFileObject)
            ->setDelimiter(';')
            ->setOutputBOM(\League\Csv\Writer::BOM_UTF8)
            ->insertOne($this->m_arTableHeader);

        if ($this->m_arData)
        {
            $this->write_rows($l_csv);
        } // if

        $l_csv->output($this->get_csv_filename());
        die;
    } // function

    /**
     * This method will write the contents of a generic multivalue-category to the given CSV file.
     *
     * @param  \League\Csv\Writer  $p_csv
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    protected function write_rows(\League\Csv\Writer $p_csv)
    {
        if (is_array($this->m_arData) && count($this->m_arData))
        {
            // Check which property has callbacks.
            foreach ($this->m_arData[0] as $key => $value)
            {
                list($class, $property) = explode('__', str_replace('isys_cmdb_dao_category_', '', $key));

                $class    = str_replace(' ', '', ucwords(str_replace('_', ' ', $class)));
                $property = str_replace(' ', '', ucwords(str_replace('_', ' ', $property)));

                $callbackClass = '\\idoit\\Module\\Cmdb\\Model\\Ci\\Category\\' . substr($class, 0, 1) . '\\' . substr($class, 1) . '\\' . $property;

                if (!empty($class) && class_exists($callbackClass) && is_a($callbackClass, 'idoit\\Module\\Cmdb\\Model\\Ci\\Category\\DynamicCallbackInterface', true))
                {
                    $callbacks[$key] = $callbackClass;
                } // if
            } // foreach

            foreach ($this->m_arData as $row)
            {
                foreach ($row as $key => &$value)
                {
                    if ((strpos($key, '__') === false && strpos($key, '###') === false) || $key == '__id__')
                    {
                        unset($row[$key]);
                        continue;
                    } // if

                    $value = _LL($value);

                    // Check if a callback is set and call it!
                    if (isset($callbacks[$key]))
                    {
                        $value = call_user_func($callbacks[$key] . '::render', $value);
                    } // if

                    $value = preg_replace('~{#[a-fA-F0-9]{3,6}}~i', '', $value);
                    $value = preg_replace('~ {\d+}~i', '', $value);
                    $value = trim(strip_tags($value));
                } // foreach

                $p_csv->insertOne($row);
            } // foreach
        } // if
    } // function
} // class