<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
/**
 * i-doit
 *
 * Export helper for global category contact
 *
 * @package     i-doit
 * @subpackage  Export
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_global_contact_export_helper extends isys_export_helper
{
    /**
     * Exports global category contact
     *
     * @return isys_export_data
     */
    public function exportContactAssignment()
    {
        $daoContactAssignment = isys_cmdb_dao_category_g_contact::instance($this->m_database);
        $contacts  = $this->export_contact(
            $this->m_row["isys_connection__isys_obj__id"],
            $daoContactAssignment->get_objTypeID($this->m_row["isys_connection__isys_obj__id"])
        );

        return new isys_export_data($contacts);
    }
} // class