<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 * DAO: specific category list for fiber/lead
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Benjamin Heisig <bheisig@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_fiber_lead extends isys_component_dao_category_table_list
{
    /**
     * Gets fields to display in the list view.
     *
     * @return  array
     */
    public function get_fields()
    {
        return [
            'isys_catg_fiber_lead_list__id'      => 'ID',
            'isys_catg_fiber_lead_list__label'   => _L('LC__CATG__FIBER_LEAD__LABEL'),
            'isys_fiber_category__title'         => _L('LC__CATG__FIBER_LEAD__CATEGORY'),
            'isys_cable_colour__title'           => _L('LC__CATG__FIBER_LEAD__COLOR'),
            'isys_catg_fiber_lead_list__damping' => _L('LC__CATG__FIBER_LEAD__DAMPING')
        ];
    } // function

    /**
     * Modify row method will be called for each row to alter its content.
     *
     * @param  array &$p_row
     */
    public function modify_row(&$p_row)
    {
        if ($p_row['isys_catg_fiber_lead_list__damping'] > 0)
        {
            $p_row['isys_catg_fiber_lead_list__damping'] .= ' DB';
        }
        else
        {
            $p_row['isys_catg_fiber_lead_list__damping'] = isys_tenantsettings::get('gui.empty_value', '-');
        } // if
    } // function
} // class