<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 * DAO: list for virtual devices
 *
 * @package    i-doit
 * @subpackage CMDB_Category_lists
 * @author     Dennis Stuecken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_catg_virtual_devices extends isys_component_dao_category_table_list
{

    /**
     * Return constant of category.
     *
     * @return  integer
     */
    public function get_category()
    {
        return C__CATG__VIRTUAL_DEVICE;
    } // function

    /**
     * Return constant of category type.
     *
     * @return  integer
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    } // function

    /**
     * Retrieve data for catg maintenance list view.
     *
     * @param   string  $p_str
     * @param   integer $p_objID
     * @param   integer $p_cRecStatus
     *
     * @return  isys_component_dao_result
     */
    public function get_result($p_str = null, $p_objID, $p_cRecStatus = null)
    {
        return isys_cmdb_dao_category_g_virtual_devices::instance($this->m_db)
            ->get_data(null, null, " AND isys_catg_virtual_device_list__isys_obj__id = " . $p_objID, null, empty($p_cRecStatus) ? $this->get_rec_status() : $p_cRecStatus);
    }

    /**
     * @param  array &$p_row
     */
    public function modify_row(&$p_row)
    {
        if (isset($p_row["isys_catg_virtual_device_list__device_type"]))
        {
            $l_data = [];

            switch (intval($p_row["isys_catg_virtual_device_list__device_type"]))
            {
                case C__VIRTUAL_DEVICE__STORAGE:
                    $p_row["device_type"] = _L("LC__CATG__STORAGE");

                    $l_dao_stor = new isys_cmdb_dao_category_g_stor(isys_application::instance()->database);

                    // Retrieve host ressource.
                    if ($p_row["isys_virtual_device_host__isys_catg_stor_list__id"] > 0)
                    {

                        // ----------- STORE ------------
                        $l_stordata = $l_dao_stor->get_data($p_row["isys_virtual_device_host__isys_catg_stor_list__id"])
                            ->__to_array();

                        $p_row["host_ressource"] = $l_stordata["isys_obj__title"] . " >> " . $l_stordata["isys_catg_stor_list__title"] . " (" . _L(
                                $l_stordata["isys_stor_manufacturer__title"]
                            ) . ")";;
                    }
                    else if ($p_row["isys_virtual_device_host__isys_catg_ldevclient_list__id"] > 0)
                    {

                        // ----------- LDEV ------------
                        $l_dao_ldevclient = new isys_cmdb_dao_category_g_ldevclient(isys_application::instance()->database);
                        $l_ldevdata       = $l_dao_ldevclient->get_data($p_row["isys_virtual_device_host__isys_catg_ldevclient_list__id"])
                            ->__to_array();

                        $p_row["host_ressource"] = $l_ldevdata["isys_obj__title"] . " >> " . $l_ldevdata["isys_catg_ldevclient_list__title"];
                    }
                    else if ($p_row["isys_virtual_device_host__isys_catg_drive_list__id"] > 0)
                    {

                        // ----------- DRIVE ------------
                        $l_dao_drive = new isys_cmdb_dao_category_g_drive(isys_application::instance()->database);
                        $l_drivedata = $l_dao_drive->get_data($p_row["isys_virtual_device_host__isys_catg_drive_list__id"])
                            ->__to_array();

                        $p_row["host_ressource"] = $l_drivedata["isys_obj__title"] . " >> " . $l_drivedata["isys_catg_drive_list__title"] . " (" . addslashes(
                                $l_drivedata["isys_catg_drive_list__driveletter"]
                            ) . ")";
                    }
                    else if ($p_row["isys_virtual_device_host__cluster_storage"])
                    {
                        $p_row["host_ressource"] = $p_row["isys_virtual_device_host__cluster_storage"];
                    } // if

                    // Retrieve local device.
                    if ($p_row["isys_virtual_device_local__isys_catg_stor_list__id"] > 0)
                    {
                        $l_stordata            = $l_dao_stor->get_data($p_row["isys_virtual_device_local__isys_catg_stor_list__id"])
                            ->__to_array();
                        $p_row["local_device"] = $l_stordata["isys_catg_stor_list__title"];
                    } // if

                    // Retrieve Type.
                    $p_row["type"] = _L($p_row["isys_virtual_storage_type__title"]);

                    break;

                case C__VIRTUAL_DEVICE__NETWORK:
                    $p_row["device_type"] = _L("LC__CMDB__CATG__NETWORK");

                    // DAO Init.
                    $l_dao = new isys_cmdb_dao_category_g_network_port(isys_application::instance()->database);

                    // Retrieve host ressource.
                    if ($p_row["isys_virtual_device_host__isys_catg_port_list__id"] > 0)
                    {
                        $l_data                  = $l_dao->get_data($p_row["isys_virtual_device_host__isys_catg_port_list__id"])
                            ->__to_array();
                        $p_row["host_ressource"] = $l_data["isys_obj__title"] . " >> " . $l_data["isys_catg_port_list__title"];
                    }
                    else if (isset($p_row["isys_virtual_device_host__switch_port_group"]) && $p_row["isys_virtual_device_host__switch_port_group"])
                    {
                        $p_row["host_ressource"] = "Switch Port Group: " . $p_row["isys_virtual_device_host__switch_port_group"];
                    } // if

                    // Retrieve local device.
                    if ($p_row["isys_virtual_device_local__isys_catg_port_list__id"] > 0)
                    {
                        $l_data                = $l_dao->get_data($p_row["isys_virtual_device_local__isys_catg_port_list__id"])
                            ->__to_array();
                        $p_row["local_device"] = $l_data["isys_catg_port_list__title"];
                    } // if

                    // Retrieve Type.
                    $p_row["type"] = _L($p_row["isys_virtual_network_type__title"]);

                    break;

                case C__VIRTUAL_DEVICE__INTERFACE:
                    $p_row["device_type"] = _L("LC__CMDB__CATG__UNIVERSAL_INTERFACE");

                    // DAO Init.
                    $l_dao = new isys_cmdb_dao_category_g_ui(isys_application::instance()->database);

                    // Retrieve host ressource.
                    if ($p_row["isys_virtual_device_host__isys_catg_ui_list__id"] > 0)
                    {
                        $l_data                  = $l_dao->get_data($p_row["isys_virtual_device_host__isys_catg_ui_list__id"])
                            ->__to_array();
                        $p_row["host_ressource"] = $l_data["isys_obj__title"] . " >> " . $l_data["isys_catg_ui_list__title"];
                    }
                    else if ($p_row["isys_virtual_device_host__cluster_ui"])
                    {
                        $p_row["host_ressource"] = $p_row["isys_virtual_device_host__cluster_ui"];
                    } // if

                    // Retrieve local ressource.
                    if ($p_row["isys_virtual_device_local__isys_catg_ui_list__id"] > 0)
                    {
                        $l_data                = $l_dao->get_data($p_row["isys_virtual_device_local__isys_catg_ui_list__id"])
                            ->__to_array();
                        $p_row["local_device"] = $l_data["isys_catg_ui_list__title"];
                    } // if

                    // Retrieve Type.
                    $p_row["type"] = _L($l_data["isys_ui_con_type__title"]);
                    break;

                default:
                    $p_row["device_type"] = "Unknown";
                    break;
            } // switch
        } // if
    } // function

    /**
     * Returns array with table headers.
     *
     * @return  array
     */
    public function get_fields()
    {
        return [
            "device_type"    => "LC__CMDB__CATG__VD__DEVICETYPE",
            "local_device"   => "LC__CMDB__CATG__VD__LOCAL_DEVICE",
            "host_ressource" => "LC__CMDB__CATG__VD__HOST_RESOURCE",
            "type"           => "LC__CMDB__CATG__VD__TYPE"
        ];
    } // function
} // class