<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
use idoit\Component\Helper\Ip;

/**
 * i-doit
 *
 * DAO: Specific net zone list.
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_cats_net_zone extends isys_component_dao_category_table_list
{
    /**
     * Method for retrieving the category ID.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function get_category()
    {
        return C__CATS__NET_ZONE;
    } // function

    /**
     * Method for retrieving the category-type.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_SPECIFIC;
    } // function

    /**
     * Order condition.
     *
     * @param   string $p_column
     * @param   string $p_direction
     *
     * @return  string
     * @author  Van Quyen Hoang <qhoang@synetics.de>
     */
    public function get_order_condition($p_column, $p_direction)
    {
        if ($p_column == 'isys_cats_net_zone_list__range_from')
        {
            $p_column = 'isys_cats_net_zone_list__range_from_long';
        }
        else if ($p_column == 'isys_cats_net_zone_list__range_to')
        {
            $p_column = 'isys_cats_net_zone_list__range_to_long';
        } // if

        return $p_column . " " . $p_direction;
    } // function

    /**
     * Method for modifying the single rows for displaying links or getting translations.
     *
     * @param   array & $p_row
     *
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function modify_row(&$p_row)
    {
        $l_net_dao = new isys_cmdb_dao_category_s_net(isys_application::instance()->database);
        $l_net_row = $l_net_dao->get_data(null, $p_row['isys_cats_net_zone_list__isys_obj__id'])
            ->get_row();

        // This is a bugfix, because we don't update the IP assignments for IPv6 yet.
        if ($l_net_row['isys_cats_net_list__isys_net_type__id'] == C__CATS_NET_TYPE__IPV6)
        {
            $p_row['isys_cats_net_zone_list__range_from'] = Ip::validate_ipv6($p_row['isys_cats_net_zone_list__range_from'], true);
            $p_row['isys_cats_net_zone_list__range_to']   = Ip::validate_ipv6($p_row['isys_cats_net_zone_list__range_to'], true);
        } // if

        $p_row['zone_object'] = isys_tenantsettings::get('gui.empty_value', '-');

        if ($p_row['isys_cats_net_zone_list__isys_obj__id__zone'] > 0)
        {
            $l_object = isys_cmdb_dao_category_g_net_zone_options::instance(isys_application::instance()->database)
                ->get_data(null, $p_row['isys_cats_net_zone_list__isys_obj__id__zone'])
                ->get_row();

            $p_row['zone_object'] = '<div class="cmdb-marker" style="background-color:' . $l_object['isys_catg_net_zone_options_list__color'] . ';"></div> ' .
                (new isys_ajax_handler_quick_info())->get_quick_info(
                    $l_object['isys_obj__id'],
                    _L($l_object['isys_obj_type__title']) . ' &raquo; ' . $l_object['isys_obj__title'],
                    C__LINK__OBJECT);
        } // if
    } // function

    /**
     * Method for retrieving the fields to display in the list-view.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.org>
     */
    public function get_fields()
    {
        return [
            'isys_cats_net_zone_list__id'              => 'ID',
            'isys_cats_net_zone_list__range_from'      => 'LC__CMDB__CATS__NET__ZONE_RANGE_FROM',
            'isys_cats_net_zone_list__range_from_long' => false,
            'isys_cats_net_zone_list__range_to'        => 'LC__CMDB__CATS__NET__ZONE_RANGE_TO',
            'isys_cats_net_zone_list__range_to_long'   => false,
            'zone_object'                               => 'LC__CMDB__CATS__NET__ZONE',
        ];
    } // function
} // class