<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Model\Ci\Table;

/**
 * i-doit
 *
 * Ci Table Property Config
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @since       1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Property
{
    /**
     * @var  boolean
     */
    private $indexed;

    /**
     * @var  string
     */
    private $class;

    /**
     * @var  string
     */
    private $key;

    /**
     * @var  string
     */
    private $categoryName;

    /**
     * @var  string
     */
    private $name;

    /**
     * @var  integer
     */
    private $customCatID;

    /**
     * @var  string
     */
    private $type;

    /**
     * Property constructor.
     *
     * @param  string  $class
     * @param  string  $key
     * @param  string  $categoryName
     * @param  string  $name
     * @param  boolean $indexed
     * @param  integer $customCatID
     * @param  string  $type
     */
    public function __construct($class = '', $key = '', $categoryName = '', $name = '', $indexed = false, $customCatID = null, $type = null)
    {
        $this->setClass($class)
            ->setKey($key)
            ->setCategoryName($categoryName)
            ->setName($name)
            ->setIndexed($indexed)
            ->setCustomCatID($customCatID)
            ->setType($type);
    } // function

    /**
     * @return boolean
     */
    public function isIndexed()
    {
        return $this->indexed;
    } // function

    /**
     * @param boolean $indexed
     *
     * @return Property
     */
    public function setIndexed($indexed)
    {
        $this->indexed = $indexed;

        return $this;
    } // function

    /**
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    } // function

    /**
     * @param string $class
     *
     * @return Property
     */
    public function setClass($class)
    {
        $this->class = $class;

        return $this;
    } // function

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    } // function

    /**
     * @param string $key
     *
     * @return Property
     */
    public function setKey($key)
    {
        $this->key = $key;

        return $this;
    } // function

    /**
     * @return string
     */
    public function getCategoryName()
    {
        return $this->categoryName;
    } // function

    /**
     * @param string $categoryName
     *
     * @return Property
     */
    public function setCategoryName($categoryName)
    {
        $this->categoryName = $categoryName;

        return $this;
    } // function

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    } // function

    /**
     * @param string $name
     *
     * @return Property
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    } // function

    /**
     * @return integer
     */
    public function getCustomCatID()
    {
        return $this->customCatID;
    } // function

    /**
     * @param integer $customCatID
     *
     * @return Property
     */
    public function setCustomCatID($customCatID)
    {
        $this->customCatID = (int) $customCatID;

        return $this;
    } // function

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    } // function

    /**
     * @param string $type
     *
     * @return Property
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    } // function
} // class