<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Model\Summary;

use idoit\Model\Summary\Summarizable;
use idoit\Model\Summary\SystemSummary;

/**
 * i-doit
 *
 * Object type summary
 *
 * @package     i-doit
 * @subpackage  Cmdb
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.7
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class GlobalCategorySummary extends SystemSummary implements Summarizable
{
    /**
     * @inherit
     * @var string
     */
    protected $namespace = 'cmdb.category.g';

    /**
     * Summarize category count. Currently only works with record status normal
     *
     * @param $objectId
     * @param $categoryId
     *
     * @return bool
     */
    public function summarize($objectId, $categoryId/*, $status = C__RECORD_STATUS__NORMAL*/)
    {
        $daoDistributor = new \isys_cmdb_dao_distributor($this->queryDao->get_database_component(), $objectId, C__CMDB__CATEGORY__TYPE_GLOBAL, null, $categoryId);
        $categoryDao    = $daoDistributor->get_category($categoryId);

        return $this->set(
            $this->concat($objectId, $categoryId, C__RECORD_STATUS__NORMAL),
            $categoryDao ? $categoryDao->get_count($objectId) : 0
        );
    }

    /**
     * @param $objectId
     * @param $categoryId
     *
     * @return int
     */
    public function getCount($objectId, $categoryId)
    {
        return $this->get(
            $this->concat($objectId, $categoryId, C__RECORD_STATUS__NORMAL)
        );
    }
}