<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Search\IndexExtension\IndexStrategy;

use idoit\Module\Search\Index\Exceptions\PropertyNotIndexableException;
use idoit\Module\Search\Index\Protocol\IndexStrategy;

/**
 * i-doit
 *
 * Cmdb Index Manager Strategies
 *
 * @package     idoit\Module\Search\Index
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Multiselect implements IndexStrategy
{

    /**
     * Return index strategy (usually an sql statement)
     *
     * @param                         $key
     * @param array                   $prop
     * @param \isys_cmdb_dao_category $dao
     * @param string                  $objectCondition
     *
     * @return string
     */
    public function get($key, array $prop, \isys_cmdb_dao_category $dao, $objectCondition = '')
    {
        // Check some prerequisites
        if (isset($prop[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][0]) &&
            isset($prop[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][1]) &&
            isset($prop[C__PROPERTY__DATA][C__PROPERTY__DATA__SOURCE_TABLE])
        )
        {
            $srcTable = $prop[C__PROPERTY__DATA][C__PROPERTY__DATA__SOURCE_TABLE];
            $refTbl   = $prop[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][0];
            $refTblId = $prop[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][1];

            if (strstr($refTblId, '.'))
            {
                $refTbl   = explode('.', $refTbl)[1];
                $refTblId = explode('.', $refTblId)[1];
            }

            return 'REPLACE INTO isys_search_idx ' .
                '(isys_search_idx__version, isys_search_idx__type, isys_search_idx__key, isys_search_idx__value, isys_search_idx__reference) ' .
                'SELECT 1, \'cmdb\', CONCAT(isys_obj__isys_obj_type__id, \'.' . $dao->get_category() . '.\', ' . $dao->get_source_table() . '.' . $dao->get_source_table() . '__id, \'.' . $key . '\'), ' .
                 $srcTable . '__title, ' . $dao->get_source_table() . '__isys_obj__id FROM ' . $dao->get_source_table() . ' ' .

                'INNER JOIN ' . $refTbl . ' ON '.
                // For catg_global.tag we have to take the reference from __isys_obj__id, for everything else it is the id of the category.
                //                                      \/   This is why we need to put an OR here.  \/                                  \/
                '(' . $dao->get_source_table() . '__isys_obj__id = ' . $refTbl . '.' . $refTblId . ' OR ' . $dao->get_source_table() . '.' . $dao->get_source_table() . '__id = ' . $refTbl . '.' . $refTblId . ') ' .
                'INNER JOIN ' . $srcTable . ' ON  ' . $srcTable . '.' . $srcTable . '__id = ' . $refTbl . '.'.$srcTable.'__id ' .
                'INNER JOIN isys_obj ON ' . $dao->get_source_table() . '__isys_obj__id = isys_obj.isys_obj__id ' .
                'WHERE !ISNULL(' . $refTbl . '.' . $refTblId . ')' . $objectCondition .
            ';';
        }

        throw new PropertyNotIndexableException(sprintf('Property %s (%s) is not indexable by the search index.', $key, get_class($dao)));
    }
}