<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Cmdb\Search\IndexExtension\IndexStrategy;

use idoit\Module\Search\Index\Protocol\IndexStrategy;

/**
 * i-doit
 *
 * Responsible for creating index strategy instances
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.8
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class StrategyProvider
{
    /**
     * @param array $prop
     *
     * @return IndexStrategy
     */
    public static function getByProp(array $prop)
    {
        // It is only needed to define special strategies. Text is default.
        $indexStrategries = [
            C__PROPERTY__INFO__TYPE__DIALOG      => 'Dialog',
            C__PROPERTY__INFO__TYPE__DIALOG_PLUS => 'Dialog',
            C__PROPERTY__INFO__TYPE__MULTISELECT => 'Multiselect',
            // C__PROPERTY__INFO__TYPE__DIALOG_LIST => 'Dialog', // Dialog list doesn't work, yet. May not needed as well..
        ];

        if (isset($indexStrategries[$prop[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE]]))
        {
            $class = __NAMESPACE__ . '\\' . $indexStrategries[$prop[C__PROPERTY__INFO][C__PROPERTY__INFO__TYPE]];

            return new $class();
        }

        return new Text();
    }
}