<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * UI: global category for custom identifiers
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Selcuk Kekec <skekec@i-doit.com>
 */
class isys_cmdb_ui_category_g_identifier extends isys_cmdb_ui_category_global
{
    /**
     * Process ui rules
     *
     * @param \isys_cmdb_dao_category $p_cat
     *
     * @return array
     * @throws \isys_exception_dao_cmdb
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        // Get rules
        $l_rules = parent::process($p_cat); // TODO: Change the autogenerated stub

        $l_rules['C__CMDB__CATG__IDENTIFIER__LAST_UPDATED']['p_strValue'] = isys_application::instance()->container->locales
            ->fmt_datetime(
                $l_rules['C__CMDB__CATG__IDENTIFIER__LAST_UPDATED']['p_strValue'],
                true,
                false
            );

        // Reset rules
        $this->get_template_component()
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules);

        return $l_rules;
    } // function

} // class