<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * DAO: global category for Stack port overview
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_g_stack_port_overview extends isys_cmdb_dao_category_global
{
    /**
     * @var string
     */
    protected $m_category = 'stack_port_overview';

    /**
     * Flag to for multivalued category
     *
     * @var bool
     */
    protected $m_multivalued = true;

    /**
     * Count method
     *
     * @param int|null $p_obj_id
     *
     * @return int
     * @throws Exception
     * @throws isys_exception_database
     */
    public function get_count($p_obj_id = null)
    {
        $l_sql = 'SELECT isys_catg_stack_member_list__id FROM isys_catg_stack_member_list
          INNER JOIN isys_catg_port_list ON isys_catg_port_list__isys_obj__id = isys_catg_stack_member_list__stack_member
          WHERE isys_catg_stack_member_list__isys_obj__id = ' . $this->convert_sql_id($p_obj_id) . ' LIMIT 1';

        return (int) $this->retrieve($l_sql)
            ->get_row_value('isys_catg_stack_member_list__id');
    } // function

    /**
     * Retrieves data which devices are connected to the remote management controller
     *
     * @param integer     $p_catg_list_id
     * @param integer     $p_obj_id
     * @param string      $p_condition
     * @param null|string $p_filter
     * @param null        $p_status
     *
     * @return isys_component_dao_result
     * @throws Exception
     * @throws isys_exception_database
     */
    public function get_data($p_catg_list_id = null, $p_obj_id = null, $p_condition = "", $p_filter = null, $p_status = null)
    {
        return isys_cmdb_dao_list_catg_stack_port_overview::instance(isys_application::instance()->database)
            ->get_result(null, $p_obj_id, C__RECORD_STATUS__NORMAL);
    } // function

    /**
     * Helper method to build the object condition
     *
     * @param int|null $p_obj_id
     *
     * @return string
     */
    public function get_object_condition($p_obj_id = null, $p_alias = 'isys_obj')
    {
        if (!empty($p_obj_id))
        {
            if (is_array($p_obj_id))
            {
                return ' AND (isys_connection__isys_obj__id ' . $this->prepare_in_condition($p_obj_id) . ') ';
            }
            else
            {
                return ' AND (isys_connection__isys_obj__id = ' . $this->convert_sql_id($p_obj_id) . ') ';
            } // if
        } // if

        return '';
    } // function

    /**
     * Validate post data method.
     *
     * @return null
     */
    public function validate_user_data()
    {
        return null;
    } // function

    /**
     * Method for returning the properties.
     *
     * @return  array
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    protected function properties()
    {
        return [];
    } // function
} // class