<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * UI: global category for Remote Management Controller
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Van Quyen Hoang <qhoang@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_stack_port_overview extends isys_cmdb_ui_category_global
{
    /**
     * Process list method.
     *
     * @param   isys_cmdb_dao_category $p_cat
     * @param   array|null             $p_get_param_override
     * @param   string|null            $p_strVarName
     * @param   string|null            $p_strTemplateName
     * @param   boolean                $p_bCheckbox
     * @param   boolean                $p_bOrderLink
     * @param   string|null            $p_db_field_name
     *
     * @throws  isys_exception_general
     * @author  Van Quyen Hoang <qhoang@i-doit.com>
     * @return  void
     */
    public function process_list(isys_cmdb_dao_category &$p_cat, $p_get_param_override = null, $p_strVarName = null, $p_strTemplateName = null, $p_bCheckbox = false, $p_bOrderLink = true, $p_db_field_name = null)
    {
        isys_component_template_navbar::getInstance()
            ->deactivate_all_buttons()
            ->hide_all_buttons();

        parent::process_list($p_cat, $p_get_param_override, $p_strVarName, $p_strTemplateName, false, $p_bOrderLink, $p_db_field_name);
        isys_application::instance()->template->smarty_tom_add_rule("tom.content.navbar.cRecStatus.p_bInvisible=1");
    } // function
} // class