<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\QCW\Provider;

/**
 * i-doit Factory Trait
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
trait CRUDCount
{
    /**
     * Counter for created entries.
     *
     * @var integer
     */
    private $created = 0;

    /**
     * Counter for read entries.
     *
     * @var integer
     */
    private $read = 0;

    /**
     * Counter for updated entries.
     *
     * @var integer
     */
    private $updated = 0;

    /**
     * Counter for deleted entries.
     *
     * @var integer
     */
    private $deleted = 0;

    /**
     * Increments the "created" counter.
     *
     * @return $this
     */
    final public function incrementCreate()
    {
        $this->created++;

        return $this;
    } // function

    /**
     * Increments the "read" counter.
     *
     * @return $this
     */
    final public function incrementRead()
    {
        $this->read++;

        return $this;
    } // function

    /**
     * Increments the "updated" counter.
     *
     * @return $this
     */
    final public function incrementUpdate()
    {
        $this->updated++;

        return $this;
    } // function

    /**
     * Increments the "deleted" counter.
     *
     * @return $this
     */
    final public function incrementDelete()
    {
        $this->deleted++;

        return $this;
    } // function

    /**
     * Returns the "created" counter.
     *
     * @return integer
     */
    final public function getCreateCounter()
    {
        return $this->created;
    } // function

    /**
     * Returns the "read" counter.
     *
     * @return integer
     */
    final public function getReadCounter()
    {
        return $this->read;
    } // function

    /**
     * Returns the "updated" counter.
     *
     * @return integer
     */
    final public function getUpdateCounter()
    {
        return $this->updated;
    } // function

    /**
     * Returns the "deleted" counter.
     *
     * @return integer
     */
    final public function getDeleteCounter()
    {
        return $this->deleted;
    } // function
} // trait