<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * Floorplan selection popup.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.0
 */
class isys_popup_qcw_adjust extends isys_component_popup
{
    /**
     * @var  isys_component_template
     */
    protected $tpl = null;

    /**
     * @var  isys_component_database
     */
    protected $db = null;

    /**
     * Constructor method.
     */
    public function __construct()
    {
        $this->db  = isys_application::instance()->database;
        $this->tpl = isys_application::instance()->template;

        parent::__construct();
    } // function

    /**
     * Method for removing the system cache. Copied from "isys_module_system->handle_cache()"
     *
     * @return  $this
     */
    protected function clear_system_cache()
    {
        $deleted = $undeleted = 0;

        isys_glob_delete_recursive(isys_glob_get_temp_dir(), $deleted, $undeleted);

        // Removing isys_cache values.
        isys_cache::keyvalue()->flush();

        isys_component_signalcollection::get_instance()->emit('system.afterFlushSystemCache');

        return $this;
    } // function

    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   array  $params
     *
     * @return  string
     */
    public function handle_smarty_include($tpl, $params)
    {
        global $g_dirs;

        return '<button type="button" onclick="' . $this->process_overlay('', 800, 600, $params) . '" class="btn btn-block">' .
            '<img src="' . $g_dirs['images'] . 'icons/silk/pencil.png" class="mr5" alt="" />' .
            '<span>' . _L('LC__UNIVERSAL__ADJUST') . '</span>' .
            '</button>';
    } // function

    /**
     * Handle specific ajax requests.
     *
     * @param   isys_module_request  $p_modreq
     *
     * @return  mixed
     * @author  Leonard Fischer <lfischer@i-doit.org>
     * @throws  isys_exception_objectbrowser
     */
    public function &handle_ajax_request(isys_module_request $p_modreq)
    {
        header('Content-Type: application/json');

        echo '{"success":true, "data":null, "message":"Extend this!"}';

        die;
    } // function

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  null
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $ajaxUrl = isys_helper_link::create_url(
            [
                C__CMDB__GET__POPUP  => str_replace('isys_popup_', '', get_class($this)),
                C__GET__AJAX_REQUEST => 'handle_ajax_request'
            ],
            true
        );

        $this->tpl->activate_editmode()
            ->assign('ajax_url', $ajaxUrl)
            ->assign('assetsDir', isys_module_quick_configuration_wizard::get_assets_dir());
    } // function
} // class