<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Module\Report\SqlQuery\Structure;

/**
 * Select condition
 *
 * @package     idoit\Module\Report\SqlQuery\Structure
 * @subpackage  Core
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.8
 */
class SelectCondition
{
    /**
     * @var array
     */
    private $condition = [];

    /**
     * @return array
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function getCondition()
    {
        return $this->condition;
    } // function

    /**
     * @param array $condition
     *
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function setCondition($condition)
    {
        $this->condition = $condition;
        return $this;
    } // function

    /**
     * @param string $condition
     *
     * @return $this
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function addCondition($condition)
    {
        $this->condition[] = $condition;
        return $this;
    } // function

    /**
     * @return string
     */
    public function __toString()
    {
        if(count($this->getCondition()))
        {
            return ' WHERE ' . ltrim(ltrim(implode(' ', $this->getCondition()), ' AND'), ' OR') . ' ';
        } // if
        return '';
    } // function

    /**
     * @param $condition
     *
     * @return SelectCondition
     */
    public static function factory($condition)
    {
        $condition = new SelectCondition($condition);
        return $condition;
    } // function

    /**
     * JoinQuery constructor.
     *
     * @param $joinQuery
     */
    public function __construct(array $condition = [])
    {
        $this->setCondition($condition);
    } // function

    /**
     * @return SelectCondition
     * @author   Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function __clone()
    {
        return new SelectCondition($this->getCondition());
    } // function
}