<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit
 *
 * Search module
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.7
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_search extends isys_module implements isys_module_interface, isys_module_authable
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU = true;
    const DISPLAY_IN_SYSTEM_MENU = false;

    // Define, that this module uses a "pretty" URL.
    const MAIN_MENU_REWRITE_LINK = true;

    const AUTOMATIC_DEEP_SEARCH_ACTIVE = 0;
    const AUTOMATIC_DEEP_SEARCH_ACTIVE_EMPTY_RESULT = 1;
    const AUTOMATIC_DEEP_SEARCH_NONACTIVE = 2;

    /**
     * @var bool
     */
    protected static $m_licenced = true;

    /**
     * Get related auth class for module
     *
     * @return isys_auth
     */
    public static function get_auth()
    {
        return isys_auth_search::instance();
    } // function

    /**
     * @param isys_module_request $p_req
     *
     * @return boolean
     */
    public function init(isys_module_request $p_req)
    {
        return is_object($p_req);
    } // function

    /**
     * Retrieves a bookmark string for mydoit.
     *
     * @param   string $p_text
     * @param   string $p_link
     *
     * @author  Kevin Mauel <kmauel@i-doit.org>
     *
     * @return  bool    true
     */
    public function mydoit_get(&$p_text, &$p_link)
    {
        $p_text[] = str_replace('{0}', $_GET['q'], _L('LC__MODULE__SEARCH__FOR'));
        $p_link = 'moduleID=' . C__MODULE__SEARCH . '&q=' . urlencode($_GET['q']);

        return true;
    }
} // class
