<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

/**
 * i-doit.
 *
 * @package    i-doit
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @version    1.0 Fri Jun 23 15:53:59 CEST 2006
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_workflow_dao_list extends isys_component_dao_object_table_list
{
    /**
     * @desc get sql
     */
    public function get_sql()
    {
        global $g_comp_template_language_manager;
        global $g_comp_database;

        switch ($_GET[C__WORKFLOW__GET__FILTER])
        {
            case "d":
                $l_filter = "AND (isys_workflow_action_parameter__key LIKE '%start_date%') " . "AND (date_format(isys_workflow_action_parameter__datetime,'%Y-%m-%d') = " . date(
                        'Y-m-d',
                        time()
                    ) . ")";
                break;
            case "m":
                $l_filter = "AND (isys_workflow_action_parameter__key LIKE '%start_date%') " . "AND (date_format(isys_workflow_action_parameter__datetime,'%Y-%m') = " . date(
                        'Y-m',
                        time()
                    ) . ")";
                break;
            default:
                $l_filter = null;
                break;
        }

        $l_dao_actions = new isys_workflow_dao_action($g_comp_database);
        $l_dao         = $l_dao_actions->get_actions(
            null,
            null,
            C__WORKFLOW__ACTION__TYPE__NEW,
            $_GET["uid"],
            null,
            null,
            $l_filter
        );

        return $l_dao->get_query();
    }

    /**
     *
     * @param null|string $p_strTableName
     * @param int         $p_object_id
     * @param null        $p_cRecStatus
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function get_result($p_strTableName, $p_object_id, $p_cRecStatus = NULL)
    {
        if ($p_object_id == 0)
        {
            $p_object_id = null;
        } // if

        return $this->retrieve($this->get_sql());
    } // function

    /**
     * Method for retrieving the field names.
     *
     * @return  array
     */
    public function get_fields()
    {
        if (empty($_POST["sort"]))
        {
            $_POST["sort"] = "isys_workflow__datetime";
            $_POST["dir"]  = "DESC";
        } // if

        return [
            "isys_workflow__id"                        => "ID",
            "isys_workflow__title"                     => "LC__TASK__DETAIL__WORKORDER__TITLE",
            "isys_workflow_type__title"                => "Workflow Type",
            "isys_workflow_action_parameter__datetime" => "LC__TASK__DETAIL__WORKORDER__START_DATE",
            "isys_workflow_category__title"            => "LC__TASK__DETAIL__WORKORDER__CATEGORY",
        ];
    } // function
} // class
