<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\ClassLoader;

use idoit\Controller\CatchallController;

/**
 * i-doit Module Loader
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class ModuleLoader extends CatchallController
{
    /**
     * @param string         $moduleName
     * @param \isys_register $request
     */
    public function boot($moduleName, \isys_register $request)
    {
        $request->module = $moduleName;

        return $this->handle($request);
    }
}