<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\Settings;
/**
 * i-doit Setting component
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

abstract class Settings
{
    /**
     * @param string $key
     * @param string $default
     *
     * @return mixed
     */
    abstract public function get($key = null, $default = '');

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return mixed
     */
    abstract public function set($key, $value);

    /**
     * @param array $setting
     *
     * @return void
     */
    abstract public function extend($setting);

    /**
     * @param string $key
     *
     * @return void
     */
    abstract public function remove($key);

    /**
     * @return void
     */
    abstract public function save();
}