<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\Settings;
/**
 * i-doit System setting component
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class System extends Settings
{
    /**
     * @param \isys_component_database $db
     *
     * @return System
     */
    public static function factory(\isys_component_database $db)
    {
        \isys_settings::initialize($db);

        return new self();
    }

    /**
     * @param null   $key
     * @param string $default
     *
     * @return mixed
     */
    public function get($key = null, $default = '')
    {
        return \isys_settings::get($key, $default);
    }

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return $this
     */
    public function set($key, $value)
    {
        \isys_settings::set($key, $value);
        return $this;
    }

    /**
     * @param array $setting
     *
     * @return void
     */
    public function extend($setting)
    {
        \isys_settings::extend($setting);
    }

    /**
     * @param string $key
     *
     * @return void
     */
    public function remove($key)
    {
        \isys_settings::remove($key);
    }

    /**
     * @return void
     */
    public function save()
    {
        \isys_settings::force_save();
    }
}