<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Component\Table\Pagerfanta\Adapter;

use idoit\Exception\Exception;
use Pagerfanta\Adapter\AdapterInterface;

/**
 * i-doit DaoAdapter for Pagerfanta.
 *
 * @package     i-doit
 * @subpackage  Component
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class DaoAdapter implements AdapterInterface
{
    /**
     * @var \isys_cmdb_dao_list_objects
     */
    protected $dao;

    /**
     * Cache for "$this->dao->get_object_count()".
     *
     * @var integer
     */
    protected $nbResults = null;

    /**
     * DaoAdapter constructor.
     *
     * @param \isys_cmdb_dao_list_objects $dao
     */
    public function __construct(\isys_cmdb_dao_list_objects $dao)
    {
        $this->dao = $dao;
    }

    /**
     * Returns the number of results.
     *
     * @return integer The number of results.
     */
    public function getNbResults()
    {
        if ($this->nbResults === null)
        {
            return ($this->nbResults = $this->dao->get_object_count());
        } // if

        return $this->nbResults;
    } // function

    /**
     * Returns an slice of the results.
     *
     * @param integer $offset The offset.
     * @param integer $length The length.
     *
     * @return array|\Traversable The slice.
     */
    public function getSlice($offset, $length)
    {
        $l_query = $this->dao->get_table_query($offset, $length);

        return $this->dao->retrieve($l_query)->__as_array();
    } // function
} // class