<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Console\Command\Cmdb\Tenant;

use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;

class EnableTenantCommand extends AbstractTenantsCommand
{
    const NAME = 'enable';

    public function getCommandDescription()
    {
        return 'Enable a new tenant';
    }

    public function getCommandDefinition()
    {
        $definition = new InputDefinition();

        $definition->addOption(new InputOption(
            'tenantId',
            null,
            InputOption::VALUE_REQUIRED,
            'Tenant Id for tenant operations'
        ));

        return $definition;
    }

    protected function executeOperation(InputInterface $input)
    {
        if ($input->getOption('tenantId') === null) {
            throw new \Exception('Provide a tenantId for this operation!');
        }

        return $this->daoTenant->activate_mandator($input->getOption('tenantId'));
    }
}
