<?php
/**
 * i-doit - Documentation and CMDB solution for IT environments
 *
 * This file is part of the i-doit framework. Modify at your own risk.
 *
 * Please visit http://www.i-doit.com/license for a full copyright and license information.
 *
 * @version     1.10
 * @package     i-doit
 * @author      synetics GmbH
 * @copyright   synetics GmbH
 * @url         http://www.i-doit.com
 * @license     http://www.i-doit.com/license
 */
namespace idoit\Model\Summary;

/**
 * i-doit Summaries
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
interface Summarizable
{
    /**
     * Get summary
     *
     * @return int
     */
    public function get($key);

    /**
     * Set summary
     *
     * @return Summarizable
     */
    public function set($key, $count = 0);

    /**
     * @param $key
     *
     * @return Summarizable
     */
    public function remove($key);

    /**
     * @param $key
     *
     * @return Summarizable
     */
    public function increment($key);

    /**
     * @param $key
     *
     * @return Summarizable
     */
    public function decrement($key);
} // class